from django.conf import settings

from ..base import HttpBulkWorker
from ..mixins.person_ticket import PersonTicketMixin
from ...dto import Result


class StartrekBase(PersonTicketMixin, HttpBulkWorker):
    method = 'POST'

    TVM2_DESTINATION_CLIENT_ID = settings.STARTREK_TVM2_CLIENT_ID

    def get_request_json(self):
        tickets_keys = self._get_keys()
        return {
            "keys": tickets_keys,
        }

    @property
    def api_url(self):
        return settings.STARTREK_API_URL

    def get_request_url(self):
        return '{}/v2/issues/_search?fields={}'.format(self.api_url, ','.join(self.TICKET_FIELDS))

    def get_prepared_data(self, response):
        response_data = {
            key: item
            for item in response
            for key in (item['key'], *item.get('aliases', []))
        }
        return response_data

    def handle_successful_response(self, response):
        data = {}
        response_data = self.get_prepared_data(response)
        for url_object in self.url_objects:
            self.add_result_for_object(response_data=response_data,
                                       url_object=url_object,
                                       data=data,
                                       )

        return Result(data=data)
