import os

from django.conf import settings

from ..base import BaseWorker
from ...dto.types import List, String, Image
from ..mixins.simple_case import NetworkLessMixin


class Worker(NetworkLessMixin, BaseWorker):
    HOSTNAME_REGEX = {'default': r'^.*(yandex(?!-team)|kinopoisk|auto\.|avto\.|(\.|^)ya\.).*',
                      }
    PATH_REGEX = r'.*'

    PATH = os.path.abspath(__file__)

    TTL_MAP = {
        'default': 86400,  # 1 день
    }

    FAVICON_TEXT = 'YandexInternal'

    def get_favicon(self, url_object):
        host = url_object.split_result.netloc
        return settings.FAVICON_SITE_TEMPLATE.format(host)

    def get_url_object_data(self, url_object):
        result = List(
            ttl=self.get_ttl(),
            value=[
                List(ttl=self.get_ttl(),
                     value=[
                         Image(
                             src=self.get_favicon(url_object),
                             text=self.FAVICON_TEXT,
                         ),
                     ],
                     action={
                         "event": "click",
                         "type": "halfscreenpreview",
                         "url": url_object.url,
                     }),
                String(value=url_object.url),
            ]
        )

        return result

