from ..base import HttpSingleWorker
from ..mixins.yql import YqlMixin
from ...dto.types import List, String, Image, User


class Worker(YqlMixin, HttpSingleWorker):
    PATH_REGEX = r'^/Operations/(?P<id>[-=\w]+)/?$'

    status_color_map = {
        'COMPLETED': 'green',
        'ERROR': 'red',
        'ABORTED': 'gray',
        'ABORTING': 'gray',
    }
    default_color = '#888C91'

    TTL_MAP = {
        'default': 1800,  # 30 минут
        'fail': 60,
        'COMPLETED': 604800,
        'ERROR': 604800,
        'ABORTED': 604800,
    }

    def get_request_url(self, url_object, api_name=None):
        return '{}/api/v2/operations/{}/meta'.format(self.get_api_host(url_object),
                                                     url_object.path_match.group('id'))

    def handle_successful_response(self, url_object, response):
        return List(
            ttl=self.get_ttl(key=response['status']),
            value=[
                Image(
                    src=self.FAVICON,
                    text=self.FAVICON_TEXT,
                ),
                String(value=response['execMode'],
                       color=self.get_color_for_status(response['status'])),
                String(value=response.get('queryTitle', response['id'])),
                User(login=response['username']),
            ]
        )

    def get_color_for_status(self, status):
        return self.status_color_map.get(status, self.default_color)
