from ..base import HttpSingleWorker
from ..mixins.yql import YqlMixin
from ...dto.types import List, String, Image, User


class Worker(YqlMixin, HttpSingleWorker):
    PATH_REGEX = '^/Queries/(?P<id>\w+)/?$'

    TTL_MAP = {
        'default': 604800,  # 1 неделя
        'fail': 60,
    }

    def get_request_url(self, url_object, api_name=None):
        return '{}/api/v2/queries/{}/meta'.format(self.get_api_host(url_object),
                                                  url_object.path_match.group('id'))

    def handle_successful_response(self, url_object, response):
        return List(
            ttl=self.get_ttl(),
            value=[
                Image(
                    src=self.FAVICON,
                    text=self.FAVICON_TEXT,
                ),
                String(value=response['title']),
                User(login=response['username']),
            ]
        )
