from ..base import BaseWorker
from ...dto import List, Image, String
from ..mixins.yql import YqlMixin
from ..mixins.simple_case import NetworkLessMixin


def format_tutorial_name(tutorial_name):
    # Replaces all underscores by spaces and inserts a dot before the first space
    # Example: "01_Select_all_columns" => "01. Select all columns"
    text = tutorial_name.replace('_', ' ')
    first_space = text.find(' ')
    if first_space >= 0:
        text = '{}.{}'.format(text[:first_space], text[first_space:])
    return text


class Worker(YqlMixin, NetworkLessMixin, BaseWorker):
    PATH_REGEX = '^/Tutorial/(?P<name>\w+)/?$'

    TTL_MAP = {
        'default': 604800,  # 1 неделя
        'fail': 60,
    }

    def get_url_object_data(self, url_object):
        return List(
            ttl=self.get_ttl(),
            value=[
                Image(
                    src=self.FAVICON,
                    text=self.FAVICON_TEXT,
                ),
                String(
                    value=format_tutorial_name(url_object.path_match.group('name'))
                )
        ])
