from ...utils.response import is_failed_response


class AsyncResponseMixin:
    """
    Используется в случае если в методе обработки
    полученного ответа от апи соответствующего
    воркера есть блокирующие вызовы
    """

    async def handle_response(self, response):
        if is_failed_response(response):
            return self.handle_failed_response(response)
        return await self.handle_successful_response(response)

    async def get_result(self):
        response = await self.get_response()
        return await self.handle_response(response)
