# coding: utf-8
import asyncio
import functools

from ids.registry import registry


class CheckInternalAccessMixin(object):
    """
    Добавляет в воркер метод проверки доступа пользователя к внутренним ресурсам.
    Если у пользователя на стаффе выставлен признак внешнего пользователя (official.affiliation==external), то доступ
    должен быть запрещен.
    """

    async def has_access(self):
        if not hasattr(self.request.yauser, 'is_external') or self.request.yauser.is_external is None:
            login = self.request.yauser.login
            token = await self.get_token()
            staff_rep = registry.get_repository('staff', 'person', user_agent=self.get_user_agent(),
                                                oauth_token=token, **self.get_request_params())
            loop = asyncio.get_event_loop()
            get_person = functools.partial(
                staff_rep.get_one,
                lookup={'login': login, '_fields': 'official.affiliation'}
            )
            task = loop.run_in_executor(self.executor, get_person)
            person = await task
            self.request.yauser.is_external = person['official']['affiliation'] == 'external'

        return not self.request.yauser.is_external
