import re
import asyncio
import functools

from django.conf import settings

from ids.helpers.oauth import get_token_by_sessionid


class PersonAuthMixin(object):
    """
    Используется, когда в апи
    соответствующего сервиса
    следует ходить с токеном
    пользователя
    """
    async def get_token(self):
        auth = self.request.META.get('HTTP_AUTHORIZATION')
        if auth:
            match = re.match('OAuth (.*)', auth)
            if match:
                return match.groups()[0]

        loop = asyncio.get_event_loop()
        get_token = functools.partial(get_token_by_sessionid,
                                      oauth_id=settings.OAUTH_CLIENT_ID,
                                      oauth_secret=settings.OAUTH_CLIENT_SECRET,
                                      sessionid=self.request.COOKIES['Session_id'],
                                      host=self.request.get_host())
        task = loop.run_in_executor(self.executor, get_token)
        token = await task
        return token
