# coding: utf-8
from intranet.magiclinks.src.links.utils.tvm_client import get_service_ticket, get_user_ticket
from intranet.magiclinks.src.links.utils.auth import is_tvm_authentication


class PersonTicketMixin(object):
    """
    Используется, когда в АПИ соответствующего сервиса следует ходить с TVM2 пользовательским и сервисным тикетами
    Исключение составляют облачные пользователи, для которых нет возможности выписать пользовательский тикет,
    в этом случае ходим с сервисным тикетом и uid пользователя в заголовках
    """

    async def get_headers(self):
        tvm2_service_ticket = await get_service_ticket(self.TVM2_DESTINATION_CLIENT_ID, self.executor)

        headers = {'X-Ya-Service-Ticket': tvm2_service_ticket}
        request = self.request

        if is_tvm_authentication(request):
            if request.yauser.raw_user_ticket:
                headers['X-Ya-User-Ticket'] = request.yauser.raw_user_ticket
            else:
                uid_header_name = 'X-UID'
                if hasattr(request, 'is_cloud_user') and request.is_cloud_user:
                    uid_header_name = 'X-CLOUD-UID'
                headers[uid_header_name] = request.yauser.uid
        else:
            tvm2_user_ticket = await get_user_ticket(
                user_ip=request.user_ip,
                server_host=request.get_host(),
                oauth_token=None,
                session_id=request.COOKIES['Session_id'],
                executor=self.executor
            )
            headers['X-Ya-User-Ticket'] = tvm2_user_ticket

        return headers
