from ...dto import Result, List, User


class StaffUserMixin:
    METHOD = 'GET'
    PATH_REGEX = '^/(?P<login>[a-zA-Z0-9_-]+)/?$'
    TTL_MAP = {
        'default': 604800,  # 1 неделя
        'fail': 100,
    }

    def handle_successful_response(self, response):
        data = {}
        prepared_data = self.get_prepared_data(response)
        for url_object in self.url_objects:
            user_login = url_object.path_match.group('login')
            user_data = prepared_data.get(user_login)
            if not user_data:
                continue
            data[url_object.url] = List(
                ttl=self.get_ttl(),
                value=[
                    User(title=self.get_user_title(user_data['name'],
                                                   prepared_data,
                                                   ),
                         login=user_login,
                         ),
                ])

        return Result(data=data)

    def handle_failed_response(self, response):
        return Result(data={})
