import os

from ...dto.types import BinaryResource


class YqlMixin:
    HOSTNAME_REGEX = {'production': '^(yql(-beta)?).yandex-team.ru$',
                      'testing': '^yql(-dev|-test).yandex-team.ru$',
                      'development': '^(yql(-dev|-test)?).yandex-team.ru$',
                      }

    api_urls = {
        'yql.yandex-team.ru': 'https://yql.yandex.net',
        'yql-beta.yandex-team.ru': 'https://yql.yandex.net',
        'yql-test.yandex-team.ru': 'https://yql-test.yandex.net',
        'yql-dev.yandex-team.ru': 'https://yql-dev.search.yandex.net',
    }

    PATH = os.path.abspath(__file__)

    FAVICON = BinaryResource('favicon.ico', PATH)
    FAVICON_TEXT = 'YQL'

    def get_api_host(self, url_object):
        return self.api_urls[url_object.split_result.netloc]
