PY3_LIBRARY(magiclinks)

OWNER(g:tools-magiclinks)

PEERDIR(
    contrib/python/attrs
    contrib/python/django/django-1.11
    contrib/python/ipython
    contrib/python/django-cors-middleware
    contrib/python/dateutil
    contrib/python/django-environ
    contrib/python/requests
    contrib/python/uwsgi
    contrib/python/aiohttp
    contrib/python/uvloop
    contrib/python/beautifulsoup4
    contrib/python/html2text
    contrib/python/pydantic

    library/python/granular_settings
    library/python/ids
    library/python/python-django-yauth
    library/python/ylog
    library/python/datasources-config-wrapper
    library/python/blackbox
    library/python/django_tools_log_context
    library/python/tvm2
)

PY_SRCS(
    __init__.py
    common_views.py
    settings.py
    manage.py
    middleware.py
    urls.py
)

RESOURCE_FILES(
    PREFIX intranet/magiclinks/src/

    settings/016-django.conf.development
    settings/090-open_graph.conf
    settings/biz/004-business.conf.development
    settings/biz/031-yauth.conf
    settings/biz/032-yauth.conf.testing
    settings/biz/032-yauth.conf.preprod
    settings/biz/053-startrek.conf
    settings/biz/003-business.conf.testing
    settings/biz/003-business.conf.preprod
    settings/biz/054-startrek.conf.testing
    settings/biz/054-startrek.conf.preprod
    settings/biz/002-business.conf
    settings/biz/050-workers.conf
    settings/biz/151-tvm2.conf
    settings/018-middleware.conf.development
    settings/018-middleware.conf
    settings/021-logging.conf
    settings/001-magiclinks.conf
    settings/011-magiclinks.conf.development
    settings/020-logstash.conf.production
    settings/015-django.conf.testing
    settings/030-yauth.conf
    settings/020-logstash.conf
    settings/intranet/067-abc.conf.testing
    settings/intranet/080-eds.conf.testing
    settings/intranet/051-goals.conf
    settings/intranet/052-goals.conf.testing
    settings/intranet/053-startrek.conf
    settings/intranet/054-startrek.conf.testing
    settings/intranet/070-nanny.conf.testing
    settings/intranet/050-workers.conf.testing
    settings/intranet/018-django.conf
    settings/intranet/070-nanny.conf
    settings/intranet/066-abc.conf
    settings/intranet/050-workers.conf
    settings/intranet/080-eds.conf
    settings/intranet/080-eds.conf.development
    settings/intranet/110-femida.conf
    settings/intranet/110-femida.conf.testing
    settings/intranet/120-zakupki.conf
    settings/intranet/120-zakupki.conf.testing
    settings/intranet/130-watcher.conf
    settings/intranet/130-watcher.conf.testing
    settings/intranet/151-tvm2.conf
    settings/017-django.conf
    settings/014-django.conf.production
    settings/015-django.conf.preprod
    settings/150-tvm2.conf
)

NO_CHECK_IMPORTS()

END()
