from mentor.mentorships.api.experience_types import router as experience_types_router
from mentor.mentorships.api.experiences import router as experiences_router
from mentor.mentorships.api.kanban import router as kanban_router
from mentor.mentorships.api.mentee_feedback import router as mentee_feedback_router
from mentor.mentorships.api.mentor import router as mentor_router
from mentor.mentorships.api.mentor_feedback import router as mentor_feedback_router
from mentor.mentorships.api.mentors import router as mentors_router
from mentor.mentorships.api.mentorships import router as mentorships_router
from mentor.mentorships.api.search import router as search_router
from mentor.mentorships.api.skills import router as skills_router
from mentor.staff.api import router as staff_router
from mentor.users.api import router as users_router

from .ninja_api import NinjaAPI

api_v1 = NinjaAPI(
    version="1", title="Mentor API", openapi_url="/docs/openapi.json", docs_url="/docs/"
)

api_v1.add_router("/experience_types", experience_types_router)
api_v1.add_router("/experiences", experiences_router)
api_v1.add_router("/mentor_feedback", mentor_feedback_router, tags=["MentorFeedback"])
api_v1.add_router("/mentee_feedback", mentee_feedback_router, tags=["MenteeFeedback"])
api_v1.add_router("/kanban", kanban_router)
api_v1.add_router("/mentor", mentor_router)
api_v1.add_router("/mentors", mentors_router)
api_v1.add_router("/mentorships", mentorships_router)
api_v1.add_router("/skills", skills_router)
api_v1.add_router("/users", users_router, tags=["Users"])
api_v1.add_router("/staff", staff_router)
api_v1.add_router("/search", search_router, tags=["Search"])
