from errorboosterclient.logbroker import LogbrokerClient

from django.conf import settings


def send_me(event: dict, source: str, topic: str, token: str):
    with LogbrokerClient(token=token) as logbroker:
        with logbroker.get_producer(source=source, topic=topic) as producer:
            event["source"] = source
            event["dc"] = settings.DEPLOY_NODE_DC
            producer.write(event)
