from tvm2 import TVM2, TVM2_USE_DAEMON
from tvmauth import BlackboxTvmId

from django.conf import settings
from django.utils.functional import SimpleLazyObject


def get_client() -> TVM2:
    allowed_clients = getattr(settings, "TVM_ALLOWED_CLIENTS", [])
    blackbox_client = getattr(BlackboxTvmId, settings.BLACKBOX_NAME)

    init_kwargs = {
        "client_id": settings.TVM_CLIENT_ID,
        "blackbox_client": blackbox_client,
        "allowed_clients": allowed_clients,
    }

    if not TVM2_USE_DAEMON:
        init_kwargs["secret"] = settings.TVM_CLIENT_SECRET

    return TVM2(**init_kwargs)


tvm2_client = SimpleLazyObject(lambda: get_client())
