from functools import wraps

from ninja.errors import HttpError

from django.utils.translation import gettext_lazy as _


def tvm_uid_required(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        tvm_uid = getattr(request, "tvm_uid", None)

        if not tvm_uid:
            raise HttpError(403, _("User-ticket не был предоставлен"))

        return view_func(request, *args, **kwargs)

    return _wrapped_view
