from datetime import datetime
from typing import Generic, List, TypeVar

from ninja import Schema
from pydantic import validator
from pydantic.generics import GenericModel

from mentor.core.validators import validate_datetime

GenericResultsType = TypeVar("GenericResultsType")


class PaginatedResponseSchema(GenericModel, Generic[GenericResultsType]):
    count: int
    has_next: bool
    results: List[GenericResultsType]


class TimeStampedSchema(Schema):
    created: datetime
    modified: datetime

    _created_validator = validator("created", allow_reuse=True)(validate_datetime)
    _modified_validator = validator("modified", allow_reuse=True)(validate_datetime)
