from typing import List

from ninja import Router

from django.utils.translation import gettext_lazy as _

from ..models import ExperienceType
from ..schemas import ExperienceTypeOut

router = Router()


@router.get(
    "/",
    response=List[ExperienceTypeOut],
    tags=["Experience Types"],
    summary=_("Получить типы опыта"),
)
def list_experience_types(request):
    return ExperienceType.objects.all().order_by("order")
