from typing import List

from ninja import Router

from django.utils.translation import gettext_lazy as _

from ..models import MenteeFeedback, MentorFeedback, Mentorship
from ..schemas import (
    KanbanMenteeFeedbackOut,
    KanbanMentorFeedbackOut,
    MenteeKanbanMentorshipOut,
    MentorKanbanMentorshipOut,
)

router = Router()


@router.get(
    "/mentees/",
    response=List[MentorKanbanMentorshipOut],
    tags=["Kanban"],
    summary=_("Получить список менторств, в котором пользователь является ментором"),
)
def retrieve_mentor_kanban(request):
    return Mentorship.objects.filter(
        mentor__user=request.user, removed_by_mentor=False
    ).select_related(
        "mentee",
        "mentee__staff_profile",
    )


@router.get(
    "/mentees/feedback/",
    response=List[KanbanMentorFeedbackOut],
    tags=["Kanban"],
    summary=_("Получить список отзывов на ментора оставленных менти"),
)
def list_kanban_mentor_feedback(request):
    return MentorFeedback.objects.filter(
        is_visible=True,
        mentor__user=request.user,
    )


@router.get(
    "/mentors/",
    response=List[MenteeKanbanMentorshipOut],
    tags=["Kanban"],
    summary=_("Получить список менторств, в котором пользователь является менти"),
)
def retrieve_mentee_kanban(request):
    return Mentorship.objects.filter(
        mentee=request.user, removed_by_mentee=False
    ).select_related(
        "mentor",
        "mentor__user",
        "mentor__user__staff_profile",
    )


@router.get(
    "/mentors/feedback/",
    response=List[KanbanMenteeFeedbackOut],
    tags=["Kanban"],
    summary=_("Получить список отзывов на менти оставленных менторами"),
)
def list_kanban_mentee_feedback(request):
    return MenteeFeedback.objects.filter(
        is_visible=True,
        mentee=request.user,
    )
