from typing import List

from ninja import Router

from django.conf import settings
from django.utils.translation import gettext_lazy as _

from ..models import Skill
from ..schemas import SkillOut

router = Router()


@router.get(
    "/",
    response=List[SkillOut],
    tags=["Skills"],
    summary=_("Список навыков"),
)
def list_skills(request, search: str = "", limit: int = 10):
    limit = min(limit, settings.PAGINATION_MAX_LIMIT)

    return Skill.objects.filter(canonical_name__icontains=search).order_by(
        "canonical_name"
    )[:limit]
