# Generated by Django 3.1.7 on 2021-04-01 12:07

from django.db import migrations, models
import django.utils.timezone
import model_utils.fields
import simple_history.models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ExperienceType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(
                        db_index=True, editable=False, verbose_name="order"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="название")),
                ("slug", models.SlugField(verbose_name="код")),
            ],
            options={
                "verbose_name": "тип опыта",
                "verbose_name_plural": "типы опыта",
            },
        ),
        migrations.CreateModel(
            name="Feedback",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("comments", models.TextField(verbose_name="комментраии")),
            ],
            options={
                "verbose_name": "отзыв",
                "verbose_name_plural": "отзывы",
            },
        ),
        migrations.CreateModel(
            name="HistoricalMentorship",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("intro", models.TextField(verbose_name="запрос от менти")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("CREATED", "Создано"),
                            ("ACCEPTED", "Одобрено"),
                            ("DECLINED", "Отклонено"),
                            ("PAUSED", "Приостановлено"),
                            ("COMPLETED", "Завершено"),
                        ],
                        default="CREATED",
                        max_length=255,
                        verbose_name="статус",
                    ),
                ),
                (
                    "status_message",
                    models.TextField(blank=True, verbose_name="сообщение статуса"),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "история",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Mentor",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("description", models.TextField(verbose_name="описание")),
                (
                    "assistance",
                    models.JSONField(default=list, verbose_name="чем могу помочь"),
                ),
                (
                    "carrier_begin",
                    models.DateField(verbose_name="Дата начала работы по профессии"),
                ),
                (
                    "staff_joined_at",
                    models.DateField(
                        blank=True, null=True, verbose_name="Дата выхода на работу"
                    ),
                ),
                (
                    "staff_department_name",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="департамент"
                    ),
                ),
                (
                    "staff_position",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="должность"
                    ),
                ),
                (
                    "staff_is_head",
                    models.BooleanField(
                        default=False, verbose_name="является руководителем"
                    ),
                ),
                (
                    "staff_is_dismissed",
                    models.BooleanField(default=False, verbose_name="уволен"),
                ),
            ],
            options={
                "verbose_name": "ментор",
                "verbose_name_plural": "менторы",
            },
        ),
        migrations.CreateModel(
            name="MentorExperience",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "begin",
                    models.DateField(blank=True, null=True, verbose_name="начало"),
                ),
                ("end", models.DateField(blank=True, null=True, verbose_name="конец")),
                ("name", models.CharField(max_length=255, verbose_name="название")),
                ("description", models.TextField(blank=True, verbose_name="описание")),
            ],
            options={
                "verbose_name": "опыт ментора",
                "verbose_name_plural": "опыт ментора",
            },
        ),
        migrations.CreateModel(
            name="Mentorship",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("intro", models.TextField(verbose_name="запрос от менти")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("CREATED", "Создано"),
                            ("ACCEPTED", "Одобрено"),
                            ("DECLINED", "Отклонено"),
                            ("PAUSED", "Приостановлено"),
                            ("COMPLETED", "Завершено"),
                        ],
                        default="CREATED",
                        max_length=255,
                        verbose_name="статус",
                    ),
                ),
                (
                    "status_message",
                    models.TextField(blank=True, verbose_name="сообщение статуса"),
                ),
            ],
            options={
                "verbose_name": "менторство",
                "verbose_name_plural": "менторства",
            },
        ),
        migrations.CreateModel(
            name="Skill",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        max_length=255, unique=True, verbose_name="название"
                    ),
                ),
                (
                    "canonical_name",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="каноническое имя"
                    ),
                ),
            ],
            options={
                "verbose_name": "навык",
                "verbose_name_plural": "навыки",
            },
        ),
    ]
