# Generated by Django 3.1.7 on 2021-06-10 14:06

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ("mentorships", "0005_unique_canonical_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="MentorFeedback",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("comments", models.TextField(verbose_name="комментарии")),
                (
                    "is_visible",
                    models.BooleanField(default=False, verbose_name="виден ментору"),
                ),
                (
                    "can_publish",
                    models.BooleanField(
                        default=False, verbose_name="можно публиковать"
                    ),
                ),
                (
                    "is_published",
                    models.BooleanField(default=False, verbose_name="опубликован"),
                ),
                (
                    "mentor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="feedback",
                        to="mentorships.mentor",
                        verbose_name="ментор",
                    ),
                ),
            ],
            options={
                "verbose_name": "отзыв",
                "verbose_name_plural": "отзывы",
            },
        ),
        migrations.AddField(
            model_name="historicalmentorship",
            name="accepted_date",
            field=models.DateTimeField(
                blank=True, null=True, verbose_name="начало менторства"
            ),
        ),
        migrations.AddField(
            model_name="historicalmentorship",
            name="completed_date",
            field=models.DateTimeField(
                blank=True, null=True, verbose_name="конец менторства"
            ),
        ),
        migrations.AddField(
            model_name="mentorship",
            name="accepted_date",
            field=models.DateTimeField(
                blank=True, null=True, verbose_name="начало менторства"
            ),
        ),
        migrations.AddField(
            model_name="mentorship",
            name="completed_date",
            field=models.DateTimeField(
                blank=True, null=True, verbose_name="конец менторства"
            ),
        ),
        migrations.DeleteModel(
            name="Feedback",
        ),
        migrations.AddField(
            model_name="mentorfeedback",
            name="mentorship",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="mentor_feedback",
                to="mentorships.mentorship",
                verbose_name="менторство",
            ),
        ),
    ]
