# Generated by Django 3.1.7 on 2021-07-19 12:33

from django.db import migrations
from mentor.mentorships.enums import ExperienceTypes


def set_experience_types(apps, schema_editor):
    model = apps.get_model("mentorships", "ExperienceType")
    idx = 1
    for key, name in ExperienceTypes.choices:
        _, created = model.objects.get_or_create(
            slug=key,
            defaults={
                "name": name,
                "order": idx,
            },
        )
        if created:
            idx += 1


class Migration(migrations.Migration):

    dependencies = [
        ("mentorships", "0008_nullable_carrier_begin"),
    ]

    operations = [migrations.RunPython(set_experience_types, migrations.RunPython.noop)]
