# Generated by Django 3.1.13 on 2021-08-27 12:02

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("mentorships", "0013_carrier_begin_is_blank"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="mentorfeedback",
            options={
                "verbose_name": "отзыв на ментора",
                "verbose_name_plural": "отзывы на ментора",
            },
        ),
        migrations.AlterField(
            model_name="mentorfeedback",
            name="is_visible",
            field=models.BooleanField(default=False, verbose_name="виден пользователю"),
        ),
        migrations.AlterField(
            model_name="mentorfeedback",
            name="mentorship",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="mentorfeedback",
                to="mentorships.mentorship",
                verbose_name="менторство",
            ),
        ),
        migrations.CreateModel(
            name="MenteeFeedback",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("comments", models.TextField(verbose_name="комментарии")),
                (
                    "is_visible",
                    models.BooleanField(
                        default=False, verbose_name="виден пользователю"
                    ),
                ),
                (
                    "can_publish",
                    models.BooleanField(
                        default=False, verbose_name="можно публиковать"
                    ),
                ),
                (
                    "is_published",
                    models.BooleanField(default=False, verbose_name="опубликован"),
                ),
                (
                    "mentee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="feedback",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="менти",
                    ),
                ),
                (
                    "mentorship",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="menteefeedback",
                        to="mentorships.mentorship",
                        verbose_name="менторство",
                    ),
                ),
            ],
            options={
                "verbose_name": "отзыв на менти",
                "verbose_name_plural": "отзывы на менти",
                "abstract": False,
            },
        ),
    ]
