from datetime import date

from ninja import Schema

from .experience_types import ExperienceTypeOut


class ExperienceIn(Schema):
    experience_type_id: int
    begin: date = None
    end: date = None
    name: str
    description: str


class ExperienceOut(Schema):
    id: int
    experience_type: ExperienceTypeOut
    begin: date = None
    end: date = None
    name: str
    description: str
