from ninja import Schema

from mentor.core.schemas import TimeStampedSchema

from ..models import Mentorship


class KanbanStaffProfileOut(Schema):
    id: int
    full_name: str
    position: str


class KanbanUserOut(Schema):
    id: int
    username: str
    staff_profile: KanbanStaffProfileOut


class MentorKanbanMentorshipOut(TimeStampedSchema):
    id: int
    mentee: KanbanUserOut
    intro: str
    status: Mentorship.Status
    status_by_id: int
    status_message: str


class KanbanMentorOut(Schema):
    id: int
    user: KanbanUserOut


class MenteeKanbanMentorshipOut(TimeStampedSchema):
    id: int
    mentor: KanbanMentorOut
    intro: str
    status: Mentorship.Status
    status_by_id: int
    status_message: str


class KanbanMentorFeedbackOut(TimeStampedSchema):
    id: int
    mentor_id: int
    mentorship_id: int
    comments: str
    can_publish: bool
    is_published: bool


class KanbanMenteeFeedbackOut(TimeStampedSchema):
    id: int
    mentee_id: int
    mentorship_id: int
    comments: str
    can_publish: bool
    is_published: bool
