from ninja import Schema

from mentor.core.schemas import TimeStampedSchema


class MenteeFeedbackIn(Schema):
    mentorship_id: int
    comments: str
    is_visible: bool
    can_publish: bool


class MenteeFeedbackOut(TimeStampedSchema):
    id: int
    mentee_id: int
    mentorship_id: int
    comments: str
    is_visible: bool
    can_publish: bool
    is_published: bool
