from datetime import date
from typing import List

from ninja import Schema

from mentor.staff.models import StaffGroup


class MentorSkillIn(Schema):
    name: str


class MentorIn(Schema):
    description: str
    assistance: List[str]
    skills: List[MentorSkillIn]
    carrier_begin: date = None
    is_published: bool = True
    is_ready_for_mentorships: bool = True


class MentorSkillOut(Schema):
    name: str
    canonical_name: str


class MentorStaffCityOut(Schema):
    id: int
    name: str


class MentorStaffOfficeOut(Schema):
    id: int
    code: str
    name: str
    city_id: int


class MentorStaffGroupOut(Schema):
    id: int
    name: str
    url: str
    group_type: StaffGroup.Types


class MentorStaffProfileOut(Schema):
    id: int
    joined_at: date = None
    is_dismissed: bool
    language_native: str
    full_name: str
    position: str
    office: MentorStaffOfficeOut = None
    city: MentorStaffCityOut = None
    groups: List[MentorStaffGroupOut]


class MentorUserOut(Schema):
    id: int
    username: str
    first_name: str
    last_name: str
    email: str
    is_active: bool
    staff_profile: MentorStaffProfileOut


class MentorOut(Schema):
    id: int
    user: MentorUserOut
    description: str
    assistance: List[str]
    skills: List[MentorSkillOut]
    carrier_begin: date = None
    feedback_count: int
    mentees_count: int
    is_published: bool
    is_ready_for_mentorships: bool
