from ninja import Schema

from mentor.core.schemas import TimeStampedSchema


class MentorFeedbackIn(Schema):
    mentorship_id: int
    comments: str
    is_visible: bool
    can_publish: bool


class MentorFeedbackOut(TimeStampedSchema):
    id: int
    mentor_id: int
    mentorship_id: int
    comments: str
    is_visible: bool
    can_publish: bool
    is_published: bool
