from datetime import date
from typing import List

from ninja import Schema

from mentor.core.schemas import TimeStampedSchema
from mentor.staff.models import StaffGroup


class MentorListSkillOut(Schema):
    id: int
    name: str
    canonical_name: str


class MentorListStaffProfileOut(Schema):
    id: int
    full_name: str
    position: str


class MentorListUserOut(Schema):
    id: int
    username: str
    staff_profile: MentorListStaffProfileOut


class MentorListMentorOut(Schema):
    id: int
    user: MentorListUserOut
    description: str
    assistance: List[str]
    skills: List[MentorListSkillOut]
    carrier_begin: date = None
    feedback_count: int
    mentees_count: int


class MentorDetailSkillOut(Schema):
    name: str
    canonical_name: str


class MentorDetailStaffCityOut(Schema):
    id: int
    name: str


class MentorDetailStaffOfficeOut(Schema):
    id: int
    code: str
    name: str
    city_id: int


class MentorDetailGroupOut(Schema):
    id: int
    name: str
    url: str
    group_type: StaffGroup.Types


class MentorDetailStaffProfileOut(Schema):
    id: int
    joined_at: date = None
    full_name: str
    position: str
    office: MentorDetailStaffOfficeOut = None
    city: MentorDetailStaffCityOut = None
    groups: List[MentorDetailGroupOut]


class MentorDetailUserOut(Schema):
    id: int
    username: str
    is_active: bool
    staff_profile: MentorDetailStaffProfileOut


class MentorDetailMentorOut(Schema):
    id: int
    user: MentorDetailUserOut
    description: str
    assistance: List[str]
    skills: List[MentorDetailSkillOut]
    carrier_begin: date = None
    feedback_count: int
    mentees_count: int
    is_published: bool
    is_ready_for_mentorships: bool
    has_active_mentorship: bool


class MentorsMentorFeedbackStaffProfileOut(Schema):
    id: int
    full_name: str


class MentorsMentorFeedbackMenteeOut(Schema):
    id: int
    username: str
    staff_profile: MentorsMentorFeedbackStaffProfileOut


class MentorsMentorFeedbackMentorshipOut(Schema):
    id: int
    mentee: MentorsMentorFeedbackMenteeOut


class MentorsMentorFeedbackOut(TimeStampedSchema):
    id: int
    mentorship: MentorsMentorFeedbackMentorshipOut
    comments: str
    is_published: bool


class MentorsExperienceTypeOut(Schema):
    id: int
    name: str
    slug: str


class MentorsExperienceOut(Schema):
    id: int
    experience_type: MentorsExperienceTypeOut
    begin: date = None
    end: date = None
    name: str
    description: str
