from ninja import Schema

from mentor.core.schemas import TimeStampedSchema

from ..models import Mentorship


class MentorshipStatusIn(Schema):
    status: Mentorship.Status
    status_message: str


class MentorshipStatusOut(Schema):
    status: Mentorship.Status
    status_message: str


class MentorshipIn(Schema):
    mentor_id: int
    intro: str


class MentorshipOut(TimeStampedSchema):
    id: int
    mentor_id: int
    mentee_id: int
    intro: str
    status: Mentorship.Status
    status_by_id: int
    status_message: str
