from typing import List

from ninja import Schema


class MinMaxFilterIn(Schema):
    min: int = None
    max: int = None


class MentorSearchFiltersIn(Schema):
    skills: List[int] = None
    cities: List[int] = None
    departments: List[int] = None
    positions: List[str] = None
    employment: List[int] = None
    education: List[int] = None
    years_in_yandex: MinMaxFilterIn = None
    years_in_carrier: MinMaxFilterIn = None
    # years_in_leadership: MinMaxFilterIn = None
    is_chief: bool = False
    has_feedback: bool = False
    has_active_mentorships: bool = False
    has_completed_mentorships: bool = False


class MentorSearchIn(Schema):
    query: str = ""
    filters: MentorSearchFiltersIn = None


class MentorSearchSuggestIn(MentorSearchIn):
    text: str = ""
    ids: List[int] = None
    size: int = None


class MentorSearchSuggestOut(Schema):
    id: int
    text: str


class MentorSuggestAllOut(Schema):
    id: int
    username: str
    first_name: str
    last_name: str


class MentorSearchSuggestAllIn(Schema):
    query: str


class MentorSearchSuggestAllOut(Schema):
    mentors: List[MentorSuggestAllOut] = None
    positions: List[MentorSearchSuggestOut] = None
    skills: List[MentorSearchSuggestOut] = None
