from typing import List

from .models import Skill
from .schemas.mentor import MentorSkillIn


def create_skills(skills_raw: List[MentorSkillIn]):
    skills = []
    canonical_names = []

    for skill_raw in skills_raw:
        canonical_name = skill_raw.name.strip().lower()

        canonical_names.append(canonical_name)
        skills.append(Skill(name=skill_raw.name, canonical_name=canonical_name))

    Skill.objects.bulk_create(skills, ignore_conflicts=True)

    return Skill.objects.filter(canonical_name__in=canonical_names)
