from ninja import Router

from django.shortcuts import get_object_or_404
from django.utils.translation import gettext_lazy as _

from .models import StaffProfile
from .schemas import StaffProfileOut

router = Router()


@router.get(
    "/profile/",
    response=StaffProfileOut,
    tags=["Staff"],
    summary=_("Получить стафф-профиль пользователя"),
)
def retrieve_staff_profile(request):
    return get_object_or_404(StaffProfile, user=request.user)
