from django.core.management.base import BaseCommand

from mentor.staff.services import load_staff_offices


class Command(BaseCommand):
    help = "Loads all offices, cities and countries from Staff"  # noqa: A003

    def add_arguments(self, parser):
        parser.add_argument(
            "--limit",
            dest="limit",
            type=int,
            help="Limit per Staff API request",
        )
        parser.add_argument(
            "--max-limit", dest="max_limit", type=int, help="Max limit of results"
        )

    def handle(self, *args, **options):
        load_staff_offices(**options)
        self.stdout.write("Done\n")
