from django.core.management.base import BaseCommand

from mentor.staff.models import StaffGroup


class Command(BaseCommand):
    def update_group(self, instance: StaffGroup):
        self.stdout.write(f"{instance.id} {instance.name} {instance.level}\n")
        instance.save()

        for child in instance.children.all():
            self.update_group(child)

    def handle(self, *args, **options):
        roots = StaffGroup.objects.filter(parent__isnull=True)

        for root in roots:
            self.update_group(root)

        self.stdout.write("Done\n")
