# Generated by Django 3.1.7 on 2021-04-15 13:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_ltree.fields
import mentor.staff.models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="StaffCity",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активна"),
                ),
                (
                    "name_ru",
                    models.CharField(max_length=255, verbose_name="название RU"),
                ),
                (
                    "name_en",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="название EN"
                    ),
                ),
            ],
            options={
                "verbose_name": "город на Стаффе",
                "verbose_name_plural": "города",
            },
            bases=(mentor.staff.models.TranslatedFieldMixin, models.Model),
        ),
        migrations.CreateModel(
            name="StaffCountry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активна"),
                ),
                ("code", models.CharField(max_length=20, verbose_name="код")),
                (
                    "name_ru",
                    models.CharField(max_length=255, verbose_name="название RU"),
                ),
                (
                    "name_en",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="название EN"
                    ),
                ),
            ],
            options={
                "verbose_name": "страна",
                "verbose_name_plural": "страны",
            },
            bases=(mentor.staff.models.TranslatedFieldMixin, models.Model),
        ),
        migrations.CreateModel(
            name="StaffGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активна"),
                ),
                (
                    "level",
                    models.PositiveIntegerField(default=0, verbose_name="уровень"),
                ),
                ("name", models.CharField(max_length=255, verbose_name="название")),
                (
                    "url",
                    models.CharField(max_length=255, verbose_name="ссылка на группу"),
                ),
                (
                    "group_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("department", "Департамент"),
                            ("service", "Служба"),
                            ("servicerole", "Служебная роль"),
                            ("wiki", "Вики"),
                        ],
                        max_length=20,
                        verbose_name="тип",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="staff.staffgroup",
                        verbose_name="родительский уровень",
                    ),
                ),
            ],
            options={
                "verbose_name": "подразделение на Стаффе",
                "verbose_name_plural": "подразделения",
                "ordering": ("level", "name"),
            },
        ),
        migrations.CreateModel(
            name="StaffOffice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активна"),
                ),
                ("code", models.CharField(max_length=255, verbose_name="код")),
                (
                    "name_ru",
                    models.CharField(max_length=255, verbose_name="название RU"),
                ),
                (
                    "name_en",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="название EN"
                    ),
                ),
                (
                    "city",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="offices",
                        to="staff.staffcity",
                        verbose_name="город",
                    ),
                ),
            ],
            options={
                "verbose_name": "офис на Стаффе",
                "verbose_name_plural": "офисы",
            },
            bases=(mentor.staff.models.TranslatedFieldMixin, models.Model),
        ),
        migrations.CreateModel(
            name="GroupNode",
            fields=[
                ("path", django_ltree.fields.PathField(unique=True)),
                (
                    "group",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="node",
                        serialize=False,
                        to="staff.staffgroup",
                        verbose_name="подразделение",
                    ),
                ),
            ],
            options={
                "verbose_name": "узел подразделения",
                "verbose_name_plural": "дерево подразделений",
                "ordering": ("path",),
            },
        ),
        migrations.CreateModel(
            name="StaffProfile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активна"),
                ),
                (
                    "joined_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="дата выхода"
                    ),
                ),
                (
                    "is_dismissed",
                    models.BooleanField(default=False, verbose_name="бывший сотрудник"),
                ),
                (
                    "language_native",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=2,
                        verbose_name="родной язык",
                    ),
                ),
                (
                    "first_name_ru",
                    models.CharField(
                        blank=True, max_length=30, verbose_name="имя (ru)"
                    ),
                ),
                (
                    "first_name_en",
                    models.CharField(
                        blank=True, max_length=30, verbose_name="имя (en)"
                    ),
                ),
                (
                    "last_name_ru",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="фамилия (ru)"
                    ),
                ),
                (
                    "last_name_en",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="фамилия (en)"
                    ),
                ),
                (
                    "position_ru",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="должность (ru)"
                    ),
                ),
                (
                    "position_en",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="должность (en)"
                    ),
                ),
                (
                    "city",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="profiles",
                        to="staff.staffcity",
                        verbose_name="город",
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True, to="staff.StaffGroup", verbose_name="подразделения"
                    ),
                ),
                (
                    "office",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="profiles",
                        to="staff.staffoffice",
                        verbose_name="офис",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "профиль на Стаффе",
                "verbose_name_plural": "профили сотрудников",
            },
            bases=(mentor.staff.models.TranslatedFieldMixin, models.Model),
        ),
        migrations.AddField(
            model_name="staffcity",
            name="country",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="cities",
                to="staff.staffcountry",
                verbose_name="страна",
            ),
        ),
        migrations.CreateModel(
            name="StaffLeadership",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        choices=[("chief", "руководитель"), ("deputy", "заместитель")],
                        default="chief",
                        max_length=255,
                        verbose_name="роль",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активно"),
                ),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="leaderships",
                        to="staff.staffgroup",
                        verbose_name="подразделение",
                    ),
                ),
                (
                    "profile",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="leaderships",
                        to="staff.staffprofile",
                        verbose_name="профиль",
                    ),
                ),
            ],
            options={
                "verbose_name": "руководство в подразделении",
                "verbose_name_plural": "руководство в подразделениях",
                "unique_together": {("profile", "group", "role")},
            },
        ),
    ]
