from datetime import date
from typing import List

from ninja import Schema

from .models import StaffGroup


class StaffCityOut(Schema):
    id: int
    name: str


class StaffOfficeOut(Schema):
    id: int
    code: str
    name: str
    city_id: int


class StaffGroupOut(Schema):
    id: int
    name: str
    url: str
    group_type: StaffGroup.Types


class StaffProfileOut(Schema):
    id: int
    joined_at: date = None
    is_dismissed: bool
    language_native: str
    full_name: str
    position: str
    office: StaffOfficeOut = None
    city: StaffCityOut = None
    groups: List[StaffGroupOut]
