from django.contrib import admin
from django.contrib.auth import admin as auth_admin
from django.contrib.auth import get_user_model
from django.db.models import JSONField
from django.utils.translation import gettext_lazy as _

from mentor.users.forms import UserChangeForm, UserCreationForm

from .models import Notification
from .widgets import PrettyJSONWidget

User = get_user_model()


@admin.register(User)
class UserAdmin(auth_admin.UserAdmin):
    form = UserChangeForm
    add_form = UserCreationForm
    fieldsets = (
        (None, {"fields": ("username", "yauid", "password")}),
        (_("Personal info"), {"fields": ("email", "first_name", "last_name")}),
        (
            _("Permissions"),
            {
                "fields": (
                    "is_active",
                    "is_staff",
                    "is_superuser",
                    "groups",
                    "user_permissions",
                ),
            },
        ),
        (_("Important dates"), {"fields": ("last_login", "date_joined")}),
        (_("Settings"), {"fields": ("settings",)}),
    )
    list_display = (
        "username",
        "email",
        "first_name",
        "last_name",
        "yauid",
        "is_staff",
        "is_superuser",
        "date_joined",
        "last_login",
    )
    search_fields = ["username", "email", "yauid"]
    add_fieldsets = (
        (
            None,
            {
                "classes": ("wide",),
                "fields": ("username", "yauid", "password1", "password2"),
            },
        ),
    )
    formfield_overrides = {
        JSONField: {"widget": PrettyJSONWidget},
    }


@admin.register(Notification)
class NotificationAdmin(admin.ModelAdmin):
    list_display = ("event", "newsletter", "is_active", "created", "modified")
    list_filter = ("event", "is_active")
    search_fields = ("newsletter",)

    formfield_overrides = {
        JSONField: {"widget": PrettyJSONWidget},
    }
