from django.core.exceptions import ImproperlyConfigured
from django.db.models import TextChoices
from django.utils.functional import SimpleLazyObject
from django.utils.translation import gettext_lazy as _

from .constants import DEFAULT_USER_SETTINGS


class NotificationEvent(TextChoices):
    """
    События для уведомлений

    """

    MENTEE_CREATED_MENTORSHIP = (
        "mentee_created_mentorship",
        _("Менти создал менторство"),
    )
    MENTEE_COMPLETED_MENTORSHIP = (
        "mentee_completed_mentorship",
        _("Менти завершил менторство"),
    )
    MENTEE_LEFT_FEEDBACK = (
        "mentee_left_feedback",
        _("Менти оставил отзыв"),
    )
    MENTOR_ACCEPTED_MENTORSHIP = (
        "mentor_accepted_mentorship",
        _("Ментор подтвердил менторство"),
    )
    MENTOR_DECLINED_MENTORSHIP = (
        "mentor_declined_mentorship",
        _("Ментор отклонил менторство"),
    )
    MENTOR_COMPLETED_MENTORSHIP = (
        "mentor_completed_mentorship",
        _("Ментор завершил менторство"),
    )
    MENTOR_LEFT_FEEDBACK = (
        "mentor_left_feedback",
        _("Ментор оставил отзыв"),
    )

    @property
    def setting_name(self):
        return f"{self.value}_notification"


def get_user_settings() -> dict:
    """
    Возвращает элементы вида: "ключ" -> "тип", "дефолтное значение" для поля settings у пользователя
    """
    settings = {}

    # add notifications
    for n in NotificationEvent:  # type: NotificationEvent
        try:
            settings[n.setting_name] = (bool, DEFAULT_USER_SETTINGS[n.setting_name])
        except KeyError as exc:
            raise ImproperlyConfigured(f"No default user settings: {exc}")

    return settings


UserSettings = SimpleLazyObject(lambda: get_user_settings())
