# Generated by Django 3.1.13 on 2021-08-16 17:02

from django.db import migrations, models
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ("users", "0002_user_settings"),
    ]

    operations = [
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "event",
                    models.CharField(
                        choices=[
                            ("mentee_created_mentorship", "Менти создал менторство"),
                            (
                                "mentee_completed_mentorship",
                                "Менти завершил менторство",
                            ),
                            ("mentee_left_feedback", "Менти оставил отзыв"),
                            (
                                "mentor_accepted_mentorship",
                                "Ментор подтвердил менторство",
                            ),
                            (
                                "mentor_declined_mentorship",
                                "Ментор отклонил менторство",
                            ),
                            ("mentor_left_feedback", "Ментор оставил отзыв"),
                        ],
                        max_length=50,
                        verbose_name="событие",
                    ),
                ),
                (
                    "newsletter",
                    models.CharField(
                        max_length=255, verbose_name="идентификатор рассылки"
                    ),
                ),
                (
                    "arguments",
                    models.JSONField(
                        default=dict, verbose_name="переменные для рассылки"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активно"),
                ),
            ],
            options={
                "verbose_name": "уведомление",
                "verbose_name_plural": "уведомления",
                "ordering": ("created",),
            },
        ),
    ]
