from model_utils.models import TimeStampedModel

from django.contrib.auth.models import AbstractUser
from django.db import models
from django.utils.translation import gettext_lazy as _

from .constants import DEFAULT_USER_SETTINGS
from .enums import NotificationEvent
from .validators import user_settings_validator


class User(AbstractUser):
    """Default user for mentor."""

    yauid = models.BigIntegerField(_("UID"), db_index=True, unique=True)
    settings = models.JSONField(
        _("Настройки"), validators=[user_settings_validator], blank=True, default=dict
    )

    YAUID_FIELD = "yauid"
    REQUIRED_FIELDS = ["yauid"]

    def clean(self) -> None:
        if not self.settings:
            self.settings = DEFAULT_USER_SETTINGS


class Notification(TimeStampedModel):
    event = models.CharField(
        _("событие"), max_length=50, choices=NotificationEvent.choices
    )
    newsletter = models.CharField(_("идентификатор рассылки"), max_length=255)
    arguments = models.JSONField(_("переменные для рассылки"), blank=True, default=dict)
    is_active = models.BooleanField(_("активно"), default=True)

    class Meta:
        ordering = ("created",)
        verbose_name = _("уведомление")
        verbose_name_plural = _("уведомления")

    def __str__(self):
        return f"{self.get_event_display()} [{self.pk}]"
