from ninja import Schema
from pydantic import create_model as create_pydantic_model

from mentor.staff.schemas import StaffProfileOut

from .enums import UserSettings


class UserIn(Schema):
    username: str
    email: str = ""


class UserPartialIn(Schema):
    email: str


class UserOut(Schema):
    id: int
    yauid: int
    username: str
    first_name: str
    last_name: str
    email: str
    is_active: bool


class UserStaffProfileOut(UserOut):
    staff_profile: StaffProfileOut


UserSettingsIn = create_pydantic_model(
    "UserSettingsIn",
    **UserSettings,
    __base__=Schema,
)


class UserSettingsOut(UserSettingsIn):
    pass
