from typing import Any, Sequence

from factory import Faker, post_generation
from factory.django import DjangoModelFactory

from django.contrib.auth import get_user_model


class UserFactory(DjangoModelFactory):

    username = Faker("user_name")
    email = Faker("email")
    yauid = Faker("pyint", min_value=100000, max_value=9999999)

    @post_generation
    def password(self, create: bool, extracted: Sequence[Any], **kwargs):
        password = (
            extracted
            if extracted
            else Faker(
                "password",
                length=42,
                special_chars=True,
                digits=True,
                upper_case=True,
                lower_case=True,
            ).evaluate(None, None, extra={"locale": None})
        )
        self.set_password(password)

    class Meta:
        model = get_user_model()
        django_get_or_create = (
            "username",
            "email",
            "yauid",
        )
