from typing import Any

from django.core.exceptions import ValidationError
from django.utils.translation import gettext_lazy as _

from .enums import UserSettings


def user_settings_validator(settings: Any) -> None:
    if not isinstance(settings, dict):
        raise ValidationError(message=_("Не является словарем"), code="NOT_A_DICT")

    for setting_key in settings:
        if setting_key not in UserSettings:
            raise ValidationError(
                message=_("Настройки {setting_key} не существует").format(
                    setting_key=setting_key
                ),
                code="KEY_DOES_NOT_EXIST",
            )

        setting_value = settings.get(setting_key)
        setting_type, default_value = UserSettings.get(setting_key)

        if not isinstance(setting_value, setting_type):
            raise ValidationError(
                message=_(
                    "Настройка {setting_key} не является типом {setting_type}"
                ).format(setting_key=setting_key, setting_type=setting_type),
                code="VALUE_TYPE_IS_INVALID",
            )
