from django.conf import settings
from django.core.paginator import Paginator


def paginated_response(object_list, page: int, limit: int):
    paginator_page = Paginator(
        object_list, per_page=min(limit, settings.PAGINATION_MAX_LIMIT)
    ).get_page(page)

    return {
        "count": paginator_page.paginator.count,
        "has_next": paginator_page.has_next(),
        "results": list(paginator_page.object_list),
    }
