from typing import Iterable, Optional

import requests
from requests.adapters import HTTPAdapter, Retry


def requests_retry_session(
    retries: int = 3,
    backoff_factor: float = 0.3,
    status_forcelist: Iterable[int] = None,
    session: Optional[requests.Session] = None,
) -> requests.Session:
    if not status_forcelist:
        status_forcelist = (500, 502, 504)

    session = session or requests.Session()
    retry = Retry(
        total=retries,
        read=retries,
        connect=retries,
        backoff_factor=backoff_factor,
        status_forcelist=status_forcelist,
    )
    adapter = HTTPAdapter(max_retries=retry)
    session.mount("http://", adapter)
    session.mount("https://", adapter)
    return session
