# This dockerfile used as source in:
# registry.yandex.net/pelican/kelvin-deps (many other dockerfiles inherits from kelvin-deps)

FROM registry.yandex.net/ubuntu:xenial

# Базовый образ с минимальным набором зависимостей

# Установка зависимостей
RUN apt-get update && apt-get install \
    --no-install-recommends --no-install-suggests --assume-yes \
    # python, node.js, postgres
    python2.7-minimal postgresql-client nodejs-4 \
    # lxml
    python-lxml=3.5.0-1build1 \
    # Pillow
    python-imaging=3.1.2-0ubuntu1.1 \
    # TVM2
    libticket-parser2-python \
    # TEX formulas generation
    yandex-education-mathjax-node \
    # Эти пакеты нужны для установки python зависимостей
    # Они удаляются при сборке приложения и не нужны для его работы
    python-pip git python2.7-dev build-essential \
    # Needed for pycurl for Celery
    gcc python-dev libssl-dev libcurl4-openssl-dev \
    # Python wrapper for local yandex geobase use
    libgeobase6-python \
    # To ease devopsing
    vim less net-tools tcpdump psmisc strace lsof \
    && rm -rf /var/lib/apt/lists/* \
# Создание симлинков для node/npm
    && update-alternatives --install /usr/bin/node node /opt/nodejs/4/bin/node 10 \
    && update-alternatives --install /usr/bin/npm npm /opt/nodejs/4/bin/npm 10 \
# Меняем права на npm (без этого не работает)
    && chmod 1777 /opt/nodejs/4/bin/npm \
# Обновляем pip и его компоненты до последней версии
    && pip install -U setuptools==44.0.0 wheel pip==9.0.3 -i https://pypi.yandex-team.ru/simple/
