from dal import autocomplete

from django.contrib.auth import get_user_model
from django.db.models.expressions import Q

User = get_user_model()


class UsersAutocomplete(autocomplete.Select2QuerySetView):
    """Вью для получения списка учеников в формах с автокомплитом"""
    def get_queryset(self):
        """
        Возвращает данные только пользователям с доступом в админку.
        Фильтрует пользователей по имени, фамилию, емейлу и юзернейму.
        """
        if not self.request.user.is_staff:
            return User.objects.none()

        qs = User.objects.all()
        if self.q:
            query = (
                Q(first_name__istartswith=self.q) |
                Q(last_name__istartswith=self.q) |
                Q(username__istartswith=self.q) |
                Q(email__istartswith=self.q)
            )
            if self.q.isdigit():
                query |= Q(id=int(self.q))
            qs = qs.filter(query)
        return qs

    def get_result_label(self, user):
        """Отдает читабельное имя пользователя"""
        return user.user_label
