from django.contrib import admin
from django.utils.translation import ugettext_lazy as _


class RawIdStudentFilter(admin.ListFilter):
    """
    Фильтр в виде формы для идентификатора курса
    """
    title = _('Идентификатор пользователя')
    parameter_name = 'student_id'
    template = 'admin/accounts/raw_id_student_filter.html'

    def __init__(self, request, params, model, model_admin):
        super(RawIdStudentFilter, self).__init__(
            request, params, model, model_admin)
        self.value = None
        if self.parameter_name in params:
            self.value = params.pop(self.parameter_name)

    def expected_parameters(self):
        return [self.parameter_name]

    def has_output(self):
        return True

    def choices(self, cl):
        return [self.value] if self.value else []

    def queryset(self, request, queryset):
        try:
            value = int(self.value)
        except (TypeError, ValueError):
            return queryset
        return queryset.filter(student_id=value)
